/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.client;

import com.google.common.collect.EvictingQueue;
import dev.ftb.extendedexchange.client.EMCOverlayPosition;
import dev.ftb.extendedexchange.client.gui.EMCFormat;
import dev.ftb.extendedexchange.config.ConfigHelper;
import java.math.BigInteger;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="extendedexchange", value={Dist.CLIENT})
public class EXClientEventHandler {
    private static int timer;
    private static BigInteger emcAmount;
    private static BigInteger lastEMC;
    private static final int RING_BUFFER_SIZE = 5;
    private static final EvictingQueue<BigInteger> emcRingBuffer;
    private static final BigInteger bufferSize;
    public static BigInteger emcRate;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91074_ != null && ++timer == 20) {
            emcAmount = Minecraft.m_91087_().f_91074_.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).map(IKnowledgeProvider::getEmc).orElse(BigInteger.ZERO);
            emcRingBuffer.add((Object)emcAmount.subtract(lastEMC));
            lastEMC = emcAmount;
            emcRate = BigInteger.ZERO;
            for (BigInteger d : emcRingBuffer) {
                emcRate = emcRate.add(d);
            }
            emcRate = emcRate.divide(bufferSize);
            timer = 0;
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        emcAmount = BigInteger.ZERO;
        timer = 0;
        emcRate = BigInteger.ZERO;
        emcRingBuffer.clear();
    }

    @SubscribeEvent
    public static void addInfoText(RenderGameOverlayEvent.Text event) {
        EMCOverlayPosition oPos;
        if (Minecraft.m_91087_().f_91074_ != null && (!((Boolean)ConfigHelper.client().general.onlyShowEMCWhenHoldingModItem.get()).booleanValue() || EXClientEventHandler.holdingValidItem((Player)Minecraft.m_91087_().f_91074_)) && (oPos = (EMCOverlayPosition)((Object)ConfigHelper.client().general.screenPosition.get())) != EMCOverlayPosition.DISABLED && emcAmount.compareTo(BigInteger.ZERO) > 0) {
            (oPos == EMCOverlayPosition.TOP_LEFT ? event.getLeft() : event.getRight()).add("EMC: " + EXClientEventHandler.getEMCRateString());
        }
    }

    @NotNull
    public static String getEMCRateString() {
        Object s = EMCFormat.INSTANCE.format(emcAmount);
        if (emcRate.signum() != 0) {
            s = (String)s + (emcRate.signum() > 0 ? ChatFormatting.GREEN + "+" : ChatFormatting.RED + "-") + EMCFormat.INSTANCE.format(emcRate.abs()) + "/s";
        }
        return s;
    }

    private static boolean holdingValidItem(Player player) {
        return EXClientEventHandler.holdingValidItem(player.m_21205_()) || EXClientEventHandler.holdingValidItem(player.m_21206_());
    }

    private static boolean holdingValidItem(ItemStack stack) {
        String namespace = stack.m_41720_().getRegistryName().m_135827_();
        return namespace.equals("extendedexchange") || namespace.equals("projecte");
    }

    static {
        lastEMC = BigInteger.ZERO;
        emcRingBuffer = EvictingQueue.create((int)5);
        bufferSize = BigInteger.valueOf(5L);
        emcRate = BigInteger.ZERO;
    }
}

